%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Name: Improved Fuzzy C- Means (IFCM) clustering image segmentation algorithm.
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Author: Amit Narahar Pujari, Email contact: amitnpujari@gmail.com
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Run time: Takes approximately 6/7 minutes to completely execute and display the final results (depending on system configuration); runs in succesion with FCM algorithm.
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Software version: Written in MATLAB 6.5 environment.
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Input parameters:
% newimag = gray level image
% lambda = initial value of parameter controlling the degree of feature (pixel intensity) attraction
% epsln = initial value of the parameter controlling the degree of distance (spacial distance) attraction
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Ouput parameters:
% final clustered images, for four clusters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function IFCM

%-------------------------------------------------------------------------------------------------------------------------------------------------------------------------


lambda = 0.47;
epsln = 0.53;
nl = 1; % this controls the neighbourhood level for ease of programming for nl = 1 the actual neighbourhood level is 2, for nl2 =2 the actual neighbourhood level is 4
[newimag,V,u,nclust] = FCM;
[xsize,ysize] = size(newimag);
cluster = length(V);

counter = 0;                                                        %initialise main counter
unew = zeros(xsize,ysize,cluster);                                  %initialise new fuzzy values
unew1 = zeros(xsize,ysize,cluster);
while  counter < 2                                                  %set a limit on the counter
    
    Fh = 0;
    fuzzytotal = 0;
    distsum = 0;
    fuzzysum = zeros(1,cluster);                                    %Initialize variables
    csize(1:cluster) = zeros;
    nclust = zeros(xsize,ysize,cluster);
    for i = 1:(xsize-1)
        for j = 1:(ysize-1)
            for k = 1:cluster
                %-------------------------------------------------------------------------------------------------------------------------------------------                
                %calculate d^2(x(i,j),v(k))
                if newimag(i,j) == V(k)                             %Check for divide by zero
                    dist1 = 1;
                else      
                    dist1 = 1/(abs(newimag(i,j) - V(k)));           %Dist between vector and cluster centre
                end 
                for newloop = 1:cluster                             %Check for divide by zeros again
                    if  newimag(i,j) == V(newloop)
                        distsum =1;
                    else      
                        distsum = distsum + 1/(abs(newimag(i,j) - V(newloop)));        %Dist between vector and all cluster centres summed together
                    end 
                end 
                %------------------------------------------------------------------------------------------------------------------------------------------
                %calculate Hij (feature attraction)
                hn = 0;
                hd = 0;
                for m = (i-nl):(i+nl)
                    for n = (j-nl):(j+nl)
                        if (m>0) && (m < xsize) && (n > 0)&& (n<ysize)
                            temph = abs(newimag(i,j)-newimag(m,n));
                            hn = hn + u(m,n,k)*temph;
                            hd = hd + temph;
                        end
                    end
                end
                
                if (hd == 0)
                    h = 1;
                else
                    h = hn/hd;
                end
                clear temph
                %-----------------------------------------------------------------------------------------------------------------------------------------
                %calculate Fij (Distance attraction)
                fn = 0;
                fd = 0;
                for m = (i-nl):(i+nl)
                    for n = (j-nl):(j+nl)
                        if (m>0) && (m < xsize) && (n > 0)&& (n<ysize)
                            tempf = ((m-i)^2 + (n-j)^2)^2;
                            fn = fn + u(m,n,k)^2*tempf;
                            fd = fd +tempf;
                        end
                    end
                end
                f = fn/fd;
                %------------------------------------------------------------------------------------------------------------------------------------------
                unew(i,j,k) = dist1/distsum*(1-h*lambda-f*epsln);                    %computes fuzzines for all vectors to each cluster centre 
                unew1(i,j,k) = dist1/distsum;
                distsum = 0;
            end
            for cloop = 1:cluster                                                    %allocate the pixels by their fuzzy memberships
                if unew(i,j,cloop) == max(unew(i,j,:)) 
                    nclust(i,j,cloop) = 50;
                    csize(cloop) = csize(cloop) + 1;                                 %cluster size for probability calculation
                end  
            end 
            for loop3 = 1:cluster
                fuzzysum(loop3) = fuzzysum(loop3) + unew(i,j,loop3)^2;               %compute the fuzzy membership sum for cluster updating 
            end
            
        end
    end
    
    temp = zeros(1,cluster);                                                         %initialize variables
    
    
    
    % -------------- Computes the fuzzy sum multiplied by image pixel-----------------------------------------------------------------------------------------
        %------------------- for calculating new cluster centres. ---------------------------------------------------------------------------------------------
    
    for looper1 = 1:cluster                         
        for looper2 = 1:xsize
            for looper3 = 1:ysize
                temp(looper1) = temp(looper1) + (unew(looper2,looper3,looper1)^2 * newimag(looper2,looper3));        %Calculate new cluster centres
            end
        end
    end
    
    
    % ------------- Calculates the new centroids for the clusters --------------------------------------------------------------------------------------------
    
    for loop5 = 1:cluster
        V(loop5) = temp(loop5)/fuzzysum(loop5)                                                                       %Update cluster centres
    end 
    
    
    
    
    % -------------- Checkto see if clustering is finished  ---------------------------------------------------------------------------------------------------
    
    if abs(unew - u) < 0.01                                                                                          %Check the error criterion
    else
        unew  = u;
    end
    counter = counter+1;
end


% ------------- Displays the final clustered images -----------------------------------------------------------------------------------------------------------

for final = 1:cluster
    figure
    imshow(nclust(:,:,final))
end
 figure
imshow(newimag)                                                                                                      %Displays final clustered images